
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define _max(a,b) (a)>(b)?(a):(b)
#define _min(a,b) (a)<(b)?(a):(b)
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
vec4 INPUT(image2d_t src_data,  __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);;
}

vec4 INPUTTEXTURE(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, (vec2)(tc.x, tc.y));
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
      __global FilterParam* param,
	  int percent,
	  int alpha) //range[0 - 100] // the gpu items/threads should be newW*newH
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	float iGlobalTime = param->cur_time / param->total_time;
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	
	vec2 tc = (fragCoord + (float2)(0.5f)) / iResolution;
	if(iResolution.x<=640.0f)
        percent=(percent+10.0f)/10.0f;
    else
        percent = ((iResolution.x/640.0f)*percent+10.0f)/10.0f;
	
	vec2 uvMosaic = (vec2)(floor(fragCoord.x/percent)*percent,floor(fragCoord.y/percent)*percent);
    vec2 mosaic = uvMosaic.xy/iResolution.xy;
	
	vec4 col = INPUT(src_data,  param, mosaic);
	vec4 origCol = INPUT(src_data, param , tc);
    vec4 outcol = mix( (vec4)(col.xyz, origCol.w), origCol, (vec4)(1.0f - alpha/100.0f));
	
    write_imagef(dest_data, coordinate, outcol );
}

	